// convert bytes into friendly format
function bytesToSize(bytes) {
    var sizes = ['Bytes', 'KB', 'MB'];
    if (bytes == 0)
        return 'n/a';
    var i = parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));
    return (bytes / Math.pow(1024, i)).toFixed(1) + ' ' + sizes[i];
}
;

// check for selected crop region
function checkForm() {
    if (parseInt($('#w').val()))
        return true;
    $('.error').html('Please select a crop region and then press Upload').show();
    return false;
}
;

// update info by cropping (onChange and onSelect events handler)
function updateInfo(e) {
    $('#x1').val(e.x);
    $('#y1').val(e.y);
    $('#x2').val(e.x2);
    $('#y2').val(e.y2);
    $('#w').val(e.w);
    $('#h').val(e.h);
}
;

// clear info by cropping (onRelease event handler)
function clearInfo() {
    $('.info #w').val('');
    $('.info #h').val('');
}
;

// Create variables (in this scope) to hold the Jcrop API and image size
var jcrop_api, boundx, boundy;

function fileSelectHandler() {

    // get selected file
    var oFile = $('#image_file')[0].files[0];

    // hide all errors
    $('.error').hide();

    // check for image type (jpg and png are allowed)
    var rFilter = /^(image\/jpeg)$/i;
    if (!rFilter.test(oFile.type)) {
        $('.error').html('Csak jpg file tölthető fel!').show();
        return;
    }

    // check for file size
    if (oFile.size > 1024 * 1024) {
        $('.error').html('A képfile mérete nem lehet 1 MB-nál nagyobb!').show();
        return;
    }

    // preview element
    var oImage = document.getElementById('preview');

    // prepare HTML5 FileReader
    var oReader = new FileReader();
    oReader.onload = function (e) {

        // e.target.result contains the DataURL which we can use as a source of the image
        oImage.src = e.target.result;
        oImage.onload = function () { // onload event handler

            // display step 2
            $('.step2').fadeIn(500);

            // display some basic image info
            var sResultFileSize = bytesToSize(oFile.size);
            $('#filesize').val(sResultFileSize);
            $('#filetype').val(oFile.type);
            //sajat
            console.log(oImage.naturalWidth);
            console.log(oImage.naturalHeight);

            nHeight = Math.ceil(500 / oImage.naturalWidth * oImage.naturalHeight);
            naturalWidth = 500;
            naturalHeight = nHeight;
            //console.log(nHeight);

            // console.log(naturalWidth);
            // console.log(naturalHeight);
            $('#filedim_X').val(oImage.naturalWidth);
            $('#filedim_Y').val(oImage.naturalHeight);
            $('#filedim_x').val(naturalWidth);
            $('#filedim_y').val(naturalHeight);
            //sajat end
            //$('#filedim').val(oImage.naturalWidth + ' x ' + oImage.naturalHeight);
            $('#preview').width(naturalWidth);
            $('#preview').height(naturalHeight);
            $('#filetype').after('<input type="hidden" id="image_source" name="image_source" value="' + oImage.src + '">');
            // destroy Jcrop if it is existed
            if (typeof jcrop_api != 'undefined') {
                jcrop_api.destroy();
                jcrop_api = null;
                // $('#preview').width(oImage.naturalWidth);
                // $('#preview').height(oImage.naturalHeight);
                // console.log('------');
                // console.log(naturalHeight);
                // console.log(naturalWidth);
                //console.log(naturalHeight);
                $('#preview').width(naturalWidth);
                $('#preview').height(naturalHeight);
                //$('#preview').css('width', naturalWidth);
                //$('#preview').css('height', naturalHeight);

            }

            setTimeout(function () {
                // initialize Jcrop
                $('#preview').Jcrop({
                    minSize: [160, 90], // min crop size
                    aspectRatio: 1.78, // keep aspect ratio 1:1
                    bgFade: true, // use fade effect
                    bgOpacity: .3, // fade opacity
                    onChange: updateInfo,
                    onSelect: updateInfo,
                    onRelease: clearInfo
                }, function () {

                    // use the Jcrop API to get the real image size
                    var bounds = this.getBounds();
                    boundx = bounds[0];
                    boundy = bounds[1];

                    // Store the Jcrop API in the jcrop_api variable
                    jcrop_api = this;
                });
            }, 1000);

        };
    };

    // read selected file as DataURL
    oReader.readAsDataURL(oFile);
}

function sliderSelectHandler(x, y) {

    // get selected file
    var oFile = $('#image_file')[0].files[0];
    var sw = x;
    var sh = y;

    if (sw >= 100)
    {
        sw = sw / 10;
        sh = sh / 10;
    }

    var sw_sh = sw / sh;


    // hide all errors
    $('.error').hide();

    // check for image type (jpg and png are allowed)
    var rFilter = /^(image\/jpeg)$/i;
    if (!rFilter.test(oFile.type)) {
        $('.error').html('Csak jpg file tölthető fel!').show();
        return;
    }

    // check for file size
    if (oFile.size > 2048 * 1024) {
        $('.error').html('A képfile mérete nem lehet 2 MB-nál nagyobb!').show();
        return;
    }

    // preview element
    var oImage = document.getElementById('preview');

    // prepare HTML5 FileReader
    var oReader = new FileReader();
    oReader.onload = function (e) {

        // e.target.result contains the DataURL which we can use as a source of the image
        oImage.src = e.target.result;
        oImage.onload = function () { // onload event handler

            // display step 2
            $('.step2').fadeIn(500);

            // display some basic image info
            var sResultFileSize = bytesToSize(oFile.size);
            $('#filesize').val(sResultFileSize);
            $('#filetype').val(oFile.type);
            //sajat
            // console.log(oImage.naturalWidth);
            //console.log(oImage.naturalHeight);
            // naturalWidth = 650;

            naturalWidth = $('#preview').width();

            nHeight = Math.ceil(naturalWidth / oImage.naturalWidth * oImage.naturalHeight);

            naturalHeight = nHeight;
            // console.log(nHeight);

            // console.log(naturalWidth);
            // console.log(naturalHeight);
            $('#filedim_X').val(oImage.naturalWidth);
            $('#filedim_Y').val(oImage.naturalHeight);
            $('#filedim_x').val(naturalWidth);
            $('#filedim_y').val(naturalHeight);
            //sajat end
            //$('#filedim').val(oImage.naturalWidth + ' x ' + oImage.naturalHeight);
            $('#preview').width(naturalWidth);
            /// $('#preview').height(naturalHeight);
            $('#filetype').after('<input type="hidden" id="image_source" name="image_source" value="' + oImage.src + '">');
            // destroy Jcrop if it is existed
            if (typeof jcrop_api != 'undefined') {
                jcrop_api.destroy();
                jcrop_api = null;
                // $('#preview').width(oImage.naturalWidth);
                // $('#preview').height(oImage.naturalHeight);
                // console.log('------');
                // console.log(naturalHeight);
                // console.log(naturalWidth);
                //console.log(naturalHeight);
                $('#preview').width(naturalWidth);
                ////  $('#preview').height(naturalHeight);
                //$('#preview').css('width', naturalWidth);
                //$('#preview').css('height', naturalHeight);

            }

            setTimeout(function () {
                // initialize Jcrop
                $('#preview').Jcrop({
                    minSize: [sw, sh],
                    //minSize: [160, 90], // min crop size
                    aspectRatio: sw_sh, // keep aspect ratio 1:1
                    bgFade: true, // use fade effect
                    bgOpacity: .3, // fade opacity
                    onChange: updateInfo,
                    onSelect: updateInfo,
                    onRelease: clearInfo
                }, function () {

                    // use the Jcrop API to get the real image size
                    var bounds = this.getBounds();
                    boundx = bounds[0];
                    boundy = bounds[1];

                    // Store the Jcrop API in the jcrop_api variable
                    jcrop_api = this;
                });
            }, 1000);

        };
    };

    // read selected file as DataURL
    oReader.readAsDataURL(oFile);
}

function sectionSelectHandler(x, y) {

    // get selected file
    var oFile = $('#image_file')[0].files[0];
    var sw = x;
    var sh = y;

    if (sw >= 100)
    {
        sw = sw / 10;
        sh = sh / 10;
    }

    var sw_sh = sw / sh;


    // hide all errors
    $('.error').hide();

    // check for image type (jpg and png are allowed)
    var rFilter = /^(image\/jpeg)$/i;
    if (!rFilter.test(oFile.type)) {
        $('.error').html('Csak jpg file tölthető fel!').show();
        return;
    }

    // check for file size
    if (oFile.size > 2048 * 1024) {
        $('.error').html('A képfile mérete nem lehet 2 MB-nál nagyobb!').show();
        return;
    }

    // preview element
    var oImage = document.getElementById('preview');

    // prepare HTML5 FileReader
    var oReader = new FileReader();
    oReader.onload = function (e) {

        // e.target.result contains the DataURL which we can use as a source of the image
        oImage.src = e.target.result;
        oImage.onload = function () { // onload event handler

            // display step 2
            $('.step2').fadeIn(500);

            // display some basic image info
            var sResultFileSize = bytesToSize(oFile.size);
            $('#filesize').val(sResultFileSize);
            $('#filetype').val(oFile.type);
            //sajat
            // console.log(oImage.naturalWidth);
            //console.log(oImage.naturalHeight);
            // naturalWidth = 650;

            naturalWidth = $('#preview').width();

            nHeight = Math.ceil(naturalWidth / oImage.naturalWidth * oImage.naturalHeight);

            naturalHeight = nHeight;
            // console.log(nHeight);

            // console.log(naturalWidth);
            // console.log(naturalHeight);
            $('#filedim_X').val(oImage.naturalWidth);
            $('#filedim_Y').val(oImage.naturalHeight);
            $('#filedim_x').val(naturalWidth);
            $('#filedim_y').val(naturalHeight);
            //sajat end
            //$('#filedim').val(oImage.naturalWidth + ' x ' + oImage.naturalHeight);
            $('#preview').width(naturalWidth);
            /// $('#preview').height(naturalHeight);
            $('#filetype').after('<input type="hidden" id="image_source" name="image_source" value="' + oImage.src + '">');
            // destroy Jcrop if it is existed
            if (typeof jcrop_api != 'undefined') {
                jcrop_api.destroy();
                jcrop_api = null;
                // $('#preview').width(oImage.naturalWidth);
                // $('#preview').height(oImage.naturalHeight);
                // console.log('------');
                // console.log(naturalHeight);
                // console.log(naturalWidth);
                //console.log(naturalHeight);
                $('#preview').width(naturalWidth);
                ////  $('#preview').height(naturalHeight);
                //$('#preview').css('width', naturalWidth);
                //$('#preview').css('height', naturalHeight);

            }

            setTimeout(function () {
                // initialize Jcrop
                $('#preview').Jcrop({
                    minSize: [sw, sh],
                    //minSize: [160, 90], // min crop size
                    aspectRatio: sw_sh, // keep aspect ratio 1:1
                    bgFade: true, // use fade effect
                    bgOpacity: .3, // fade opacity
                    onChange: updateInfo,
                    onSelect: updateInfo,
                    onRelease: clearInfo
                }, function () {

                    // use the Jcrop API to get the real image size
                    var bounds = this.getBounds();
                    boundx = bounds[0];
                    boundy = bounds[1];

                    // Store the Jcrop API in the jcrop_api variable
                    jcrop_api = this;
                });
            }, 1000);

        };
    };

    // read selected file as DataURL
    oReader.readAsDataURL(oFile);
}

function menupicSelectHandler(x, y) {

    // get selected file
    var oFile = $('#image_file')[0].files[0];
    var sw = x;
    var sh = y;

    if (sw >= 100)
    {
        sw = sw / 10;
        sh = sh / 10;
    }

    var sw_sh = sw / sh;


    // hide all errors
    $('.error').hide();

    // check for image type (jpg and png are allowed)
    var rFilter = /^(image\/jpeg)$/i;
    if (!rFilter.test(oFile.type)) {
        $('.error').html('Csak jpg file tölthető fel!').show();
        return;
    }

    // check for file size
    if (oFile.size > 2048 * 1024) {
        $('.error').html('A képfile mérete nem lehet 2 MB-nál nagyobb!').show();
        return;
    }

    // preview element
    var oImage = document.getElementById('preview');

    // prepare HTML5 FileReader
    var oReader = new FileReader();
    oReader.onload = function (e) {

        // e.target.result contains the DataURL which we can use as a source of the image
        oImage.src = e.target.result;
        oImage.onload = function () { // onload event handler

            // display step 2
            $('.step2').fadeIn(500);

            // display some basic image info
            var sResultFileSize = bytesToSize(oFile.size);
            $('#filesize').val(sResultFileSize);
            $('#filetype').val(oFile.type);
            //sajat
            //console.log(oImage.naturalWidth);
            // console.log(oImage.naturalHeight);
            naturalWidth = 650;
            nHeight = Math.ceil(naturalWidth / oImage.naturalWidth * oImage.naturalHeight);

            naturalHeight = nHeight;
            //console.log(nHeight);

            // console.log(naturalWidth);
            // console.log(naturalHeight);
            $('#filedim_X').val(oImage.naturalWidth);
            $('#filedim_Y').val(oImage.naturalHeight);
            $('#filedim_x').val(naturalWidth);
            $('#filedim_y').val(naturalHeight);
            //sajat end
            //$('#filedim').val(oImage.naturalWidth + ' x ' + oImage.naturalHeight);
            $('#preview').width(naturalWidth);
            $('#preview').height(naturalHeight);
            $('#filetype').after('<input type="hidden" id="image_source" name="image_source" value="' + oImage.src + '">');
            // destroy Jcrop if it is existed
            if (typeof jcrop_api != 'undefined') {
                jcrop_api.destroy();
                jcrop_api = null;
                // $('#preview').width(oImage.naturalWidth);
                // $('#preview').height(oImage.naturalHeight);
                // console.log('------');
                // console.log(naturalHeight);
                // console.log(naturalWidth);
                //console.log(naturalHeight);
                $('#preview').width(naturalWidth);
                $('#preview').height(naturalHeight);
                //$('#preview').css('width', naturalWidth);
                //$('#preview').css('height', naturalHeight);

            }

            setTimeout(function () {
                // initialize Jcrop
                $('#preview').Jcrop({
                    minSize: [sw, sh],
                    //minSize: [160, 90], // min crop size
                    aspectRatio: sw_sh, // keep aspect ratio 1:1
                    bgFade: true, // use fade effect
                    bgOpacity: .3, // fade opacity
                    onChange: updateInfo,
                    onSelect: updateInfo,
                    onRelease: clearInfo
                }, function () {

                    // use the Jcrop API to get the real image size
                    var bounds = this.getBounds();
                    boundx = bounds[0];
                    boundy = bounds[1];

                    // Store the Jcrop API in the jcrop_api variable
                    jcrop_api = this;
                });
            }, 1000);

        };
    };

    // read selected file as DataURL
    oReader.readAsDataURL(oFile);
}



